<?php get_header();

/**
 * Setup Dynamic Sidebar
 */

list( $iron_soundrise_has_sidebar, $iron_soundrise_sidebar_position, $iron_soundrise_sidebar_area ) = Iron_soundrise::setupDynamicSidebar( $post->ID );

?>
		<!-- container -->
		<div class="container">
		<div class="boxed">

		<?php
		$iron_soundrise_single_title = Iron_soundrise::getOption('single_video_page_title');
		if(!empty($iron_soundrise_single_title)):
		?>

			<div class="page-title <?php (Iron_soundrise::isPageTitleUppercase() == true) ? 'uppercase' : '';?>">
			<span class="heading-t"></span>
				<h1><?php echo esc_html($iron_soundrise_single_title); ?></h1>
			<?php Iron_soundrise::displayPageTitleDivider(); ?>
		</div>


		<?php endif; ?>

<?php
		if ( $iron_soundrise_has_sidebar ) :
?>
			<div id="twocolumns" class="content__wrapper<?php if ( 'left' === $iron_soundrise_sidebar_position ) echo ' content--rev'; ?>">
				<div id="content" class="content__main">
<?php
		endif;

if ( have_posts() ) :
	while ( have_posts() ) : the_post();
?>
					<!-- single-post video-post -->
					<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<?php $iron_soundrise_video_url = Iron_soundrise::getField( 'video_url', $post->ID );?>
						<?php if(!empty( $iron_soundrise_video_url ) ): ?>
						<!-- video-block -->
						<div class="video-block">
								<?php echo wp_oembed_get( esc_url( $iron_soundrise_video_url ) ); ?>
						</div>
						<?php endif; ?>
						<?php if( Iron_soundrise::getField( 'hide_page_title', $post->ID ) != '1' ):?>
						<h4><?php the_title(); ?></h4>
						<?php endif ?>

						<div class="entry">
							<?php the_content(); ?>
							<?php wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'soundrise' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) ); ?>
						</div>

<?php get_template_part('parts/share'); ?>

<?php comments_template(); ?>
					</div>
<?php
	endwhile;
endif;

if ( $iron_soundrise_has_sidebar ) :
?>
				</div>

				<aside id="sidebar" class="sr_it-content-side widget-area widget-area--<?php echo esc_attr( $iron_soundrise_sidebar_area ); ?>">
<?php
	do_action('before_ironband_sidebar_dynamic_sidebar', 'single-video.php');

	dynamic_sidebar( $iron_soundrise_sidebar_area );

	do_action('after_ironband_sidebar_dynamic_sidebar', 'single-video.php');
?>
				</aside>
			</div>
<?php
endif;
?>
			</div>

		</div>
	<?php get_footer(); ?>
