<?php

get_header();
$iron_soundrise_artist_meta = get_post_meta($post->ID);
the_post();

$iron_soundrise_artist_featured_album = ( get_field('artist_hero_playlist') == 'null' )? false : get_field('artist_hero_playlist') ;
$iron_soundrise_artist_desc = get_field('artist_desc');
$iron_soundrise_artist_social = get_field('artist_social');
$iron_soundrise_artist_link = get_field('artist_link');
$iron_soundrise_artist_contact = get_field('artist_contact');
$iron_soundrise_artist_download = get_field('artist_download');

?>

<!-- container -->
<div class="container">
	<div class="boxed">
		<article id="post-<?php echo esc_attr( $post->ID ) ?>" <?php post_class( $iron_soundrise_banner_typeCSS ); ?>>
		<div class="entry">
			<?php if($iron_soundrise_artist_featured_album):?>
			<div class="artist_player" data-url-playlist="<?php echo esc_url(home_url('?load=playlist.json&amp;albums='.$iron_soundrise_artist_featured_album.''))?>" >

			    <div class="playerNowPlaying">
			        <div class="album-art">
			            <img src=""/>
			        </div>
			        <div class="metadata">
			            <div class="track-name"></div>
			            <div class="album-title"></div>
			        </div>
			    </div>
			    <div class="player">
			    <div class="progressLoading"></div>
			    <div id="artistPlayer" class="wave"></div>

			    <div class="control">
			            <div class="previous">
			                <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 10.2 11.7" style="enable-background:new 0 0 10.2 11.7;" xml:space="preserve">
								<polygon points="10.2,0 1.4,5.3 1.4,0 0,0 0,11.7 1.4,11.7 1.4,6.2 10.2,11.7"></polygon>
							</svg>
			            </div>
			            <div class="play">
			                <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 17.5 21.2" style="enable-background:new 0 0 17.5 21.2;" xml:space="preserve">
								<path d="M0,0l17.5,10.9L0,21.2V0z"></path>

								<rect width="6" height="21.2"></rect>
								<rect x="11.5" width="6" height="21.2"></rect>
							</svg>
			            </div>
			            <div class="next">
			                <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 10.2 11.7" style="enable-background:new 0 0 10.2 11.7;" xml:space="preserve">
								<polygon points="0,11.7 8.8,6.4 8.8,11.7 10.2,11.7 10.2,0 8.8,0 8.8,5.6 0,0"></polygon>
							</svg>
			            </div>
			        </div>
			    </div>
			    <div class="playlist"></div>
			</div>
			<?php endif ?>
			<div class="artist_content padding vc_col-sm-8">
				<?php the_content(); ?>
			</div>
			<div class="artist_sidebar  padding vc_col-sm-4">
				<?php if( $iron_soundrise_artist_desc ):?>
					<div class="artist_desc sr_it-meta">
						<h1><?php the_title()?></h1>
						<?php echo wp_kses_post( apply_filters( 'the_content', $iron_soundrise_artist_desc ) )?>
					</div>
				<?php endif ?>
				<?php if( $iron_soundrise_artist_social ):?>
					<div class="artist_social sr_it-meta">
						<h4><?php esc_html_e('Follow','soundrise')?></h4>
						<?php for ($i = 0; $i < $iron_soundrise_artist_social; $i++) : ?>
							<div class="social_icon">

								<a href="<?php echo esc_url( $iron_soundrise_artist_meta['artist_social_'.$i.'_artist_social_link'][0] ) ?>" target="_blank">
									<i class="fa fa-2x <?php echo esc_attr( $iron_soundrise_artist_meta['artist_social_'.$i.'_artist_social_icon'][0] )?>"></i>
									<?php echo wp_kses_post( $iron_soundrise_artist_meta['artist_social_'.$i.'_artist_social_label'][0] ) ?>
								</a>
							</div>
						<?php endfor ?>

					</div>
				<?php endif ?>

				<?php if( $iron_soundrise_artist_link ):?>
					<div class="artist_link sr_it-meta">
						<h4><?php esc_html_e('Website','soundrise')?></h4>
						<?php for ($i = 0; $i < $iron_soundrise_artist_link; $i++) : ?>

							<a href="<?php echo esc_url($iron_soundrise_artist_meta['artist_link_'.$i.'_artist_link_link'][0] ) ?>" target="_blank">
								<?php echo wp_kses_post( $iron_soundrise_artist_meta['artist_link_'.$i.'_artist_link_label'][0] )?>
							</a></br>

						<?php endfor ?>

					</div>
				<?php endif ?>

				<?php if( $iron_soundrise_artist_contact ):?>
					<div class="artist_contact sr_it-meta">
						<h4><?php esc_html_e('CONTACT & BOOKING','soundrise')?></h4>
						<?php echo wp_kses_post( apply_filters( 'the_content', $iron_soundrise_artist_contact ) ) ?>
					</div>
				<?php endif ?>

				<?php if( $iron_soundrise_artist_download ):?>
					<div class="artist_download sr_it-meta">
						<h4><?php esc_html_e('Downloads','soundrise')?></h4>
						<?php for ($i = 0; $i < $iron_soundrise_artist_download; $i++) : ?>

							<a href="<?php echo esc_url(wp_get_attachment_url($iron_soundrise_artist_meta['artist_download_'.$i.'_artist_download_link'][0]) ) ?>" target="_blank">
								<?php echo wp_kses_post( $iron_soundrise_artist_meta['artist_download_'.$i.'_artist_download_label'][0] ) ?>
							</a></br>

						<?php endfor ?>

					</div>
				<?php endif ?>
			</div>
		</div>
		</article>
	</div>
</div>
<!-- NAVIGATION -->
<div class="sr_it-artist-nav sr_it-nav">
	<div class="sr_it-prev-wrap">
	<?php $prev_post =  get_previous_post();
	if (!empty( $prev_post )): ?>
		<a href="<?php echo esc_url( get_permalink($prev_post->ID) ) ?>" class="sr_it-prev">
			<i class="fas fa-long-arrow-alt-left sr_it-arrow"></i>
			<div class="sr_it-text"><?php echo esc_html__("Previous Artist", 'soundrise'); ?></div>
			<div class="sr_it-navTitle-text"><?php echo wp_kses_post( $prev_post->post_title ) ?></div>
			<div class="clear"></div>

		</a>
	<?php endif; ?>
	</div>
	<div class="sr_it-next-wrap">
	<?php
	$next_post = get_next_post();
	if (!empty( $next_post )): ?>
		<a href="<?php echo esc_url(get_permalink($next_post->ID) ) ?>" class="sr_it-next">
			<i class="fas fa-long-arrow-alt-right sr_it-arrow"></i>
			<div class="sr_it-text"><?php echo esc_html__("Next Artist", 'soundrise'); ?></div>
			<div class="sr_it-navTitle-text"><?php echo wp_kses_post( $next_post->post_title ) ?></div>
			<div class="clear"></div>

		</a>
	<?php endif; ?>
	</div>
	<div class="clear"></div>
</div>


<?php get_footer(); ?>