<?php
if( function_exists('is_shop') && is_shop() ){
	$post_id = wc_get_page_id('shop');
}else{
	$post_id = $post->ID;
}

$iron_soundrise_banner_bg_style = '';
$iron_soundrise_banner_classes = array();
$iron_soundrise_banner_parallax = get_field('banner_parallax', $post_id);
$iron_soundrise_banner_fullscreen = Iron_soundrise::getField('banner_fullscreen', $post_id );
$iron_soundrise_banner_content_type = get_field('banner_content_type', $post_id);
$iron_soundrise_banner_texteditor_content = get_field('banner_texteditor_content', $post_id, false);
$iron_soundrise_banner_title = get_field('banner_title', $post_id);
$iron_soundrise_banner_subtitle = get_field('banner_subtitle', $post_id);
$iron_soundrise_banner_horizontal_content_alignment = get_field('banner_horizontal_content_alignment', $post_id);
$iron_soundrise_banner_vertical_content_alignment = get_field('banner_vertical_content_alignment', $post_id);

if( $iron_soundrise_banner_fullscreen ) array_push($iron_soundrise_banner_classes, 'fullscreen-banner');
if( $iron_soundrise_banner_parallax ) array_push( $iron_soundrise_banner_classes, 'parallax-banner' );
?>


<div id="page-banner" class="<?php echo esc_attr( implode( ' ',$iron_soundrise_banner_classes ) ); ?>">
	<div class="page-banner-bg"></div>
	<div class="page-banner-content">
		<div class="inner <?php echo esc_attr( $iron_soundrise_banner_vertical_content_alignment ) ?>">
			<div class="page-banner-row">
			<?php if($iron_soundrise_banner_content_type === 'advanced-content') : ?>
				<?php
					echo wp_kses_post( apply_filters( 'the_content', $iron_soundrise_banner_texteditor_content ) );
				?>
			<?php else : ?>
				<h1 class="page-title <?php echo esc_attr( $iron_soundrise_banner_horizontal_content_alignment ) ?>">
					<?php echo wp_kses_post( $iron_soundrise_banner_title) ?>
				</h1>
				<span class="page-subtitle <?php echo esc_attr( $iron_soundrise_banner_horizontal_content_alignment ) ?>">
					<?php echo wp_kses_post( $iron_soundrise_banner_subtitle ) ?>
				</span>
			<?php endif; ?>
			</div>
		</div>
	</div>
</div>